---@meta

---@class FAudioGameplayRequirements
---@field Preset UAudioRequirementPreset
---@field Custom FGameplayTagQuery
local FAudioGameplayRequirements = {}



---@class IAudioComponentGroupExtension : IInterface
local IAudioComponentGroupExtension = {}


---@class IAudioGameplayCondition : IInterface
local IAudioGameplayCondition = {}

---@param Position FVector
---@return boolean
function IAudioGameplayCondition:ConditionMet_Position(Position) end
---@return boolean
function IAudioGameplayCondition:ConditionMet() end


---@class IAudioGameplayVolumeInteraction : IInterface
local IAudioGameplayVolumeInteraction = {}

function IAudioGameplayVolumeInteraction:OnListenerExit() end
function IAudioGameplayVolumeInteraction:OnListenerEnter() end


---@class UAudioComponentGroup : USceneComponent
---@field OnStopped FAudioComponentGroupOnStopped
---@field OnKilled FAudioComponentGroupOnKilled
---@field OnVirtualized FAudioComponentGroupOnVirtualized
---@field OnUnvirtualized FAudioComponentGroupOnUnvirtualized
---@field Components TArray<UAudioComponent>
---@field ParamsToSet TArray<FAudioParameter>
---@field PersistentParams TArray<FAudioParameter>
---@field Extensions TArray<TScriptInterface<IAudioComponentGroupExtension>>
local UAudioComponentGroup = {}

---@param Object UObject
function UAudioComponentGroup:UnsubscribeObject(Object) end
---@param ParamName FName
---@param Delegate FSubscribeToStringParamDelegate
function UAudioComponentGroup:SubscribeToStringParam(ParamName, Delegate) end
---@param EventName FName
---@param Delegate FSubscribeToEventDelegate
function UAudioComponentGroup:SubscribeToEvent(EventName, Delegate) end
---@param ParamName FName
---@param Delegate FSubscribeToBoolDelegate
function UAudioComponentGroup:SubscribeToBool(ParamName, Delegate) end
---@param Sound USoundBase
---@param FadeTime float
function UAudioComponentGroup:StopSound(Sound, FadeTime) end
---@param Actor AActor
---@return UAudioComponentGroup
function UAudioComponentGroup:StaticGetOrCreateComponentGroup(Actor) end
---@param InVolume float
function UAudioComponentGroup:SetVolumeMultiplier(InVolume) end
---@param InPitch float
function UAudioComponentGroup:SetPitchMultiplier(InPitch) end
---@param InFrequency float
function UAudioComponentGroup:SetLowPassFilter(InFrequency) end
---@param ComponentToRemove UAudioComponent
function UAudioComponentGroup:RemoveExternalComponent(ComponentToRemove) end
---@param NewExtension TScriptInterface<IAudioComponentGroupExtension>
function UAudioComponentGroup:RemoveExtension(NewExtension) end
---@return boolean
function UAudioComponentGroup:IsVirtualized() end
---@return boolean
function UAudioComponentGroup:IsPlayingAny() end
---@param ParamName FName
---@return FString
function UAudioComponentGroup:GetStringParamValue(ParamName) end
---@param ParamName FName
---@return float
function UAudioComponentGroup:GetFloatParamValue(ParamName) end
---@param ParamName FName
---@return boolean
function UAudioComponentGroup:GetBoolParamValue(ParamName) end
function UAudioComponentGroup:EnableVirtualization() end
function UAudioComponentGroup:DisableVirtualization() end
function UAudioComponentGroup:BroadcastStopAll() end
function UAudioComponentGroup:BroadcastKill() end
---@param EventName FName
function UAudioComponentGroup:BroadcastEvent(EventName) end
---@param ComponentToAdd UAudioComponent
function UAudioComponentGroup:AddExternalComponent(ComponentToAdd) end
---@param NewExtension TScriptInterface<IAudioComponentGroupExtension>
function UAudioComponentGroup:AddExtension(NewExtension) end


---@class UAudioGameplayComponent : UActorComponent
local UAudioGameplayComponent = {}


---@class UAudioParameterComponent : UAudioGameplayComponent
---@field ActiveComponents TArray<TWeakObjectPtr<UAudioComponent>>
---@field Parameters TArray<FAudioParameter>
local UAudioParameterComponent = {}

---@return TArray<FAudioParameter>
function UAudioParameterComponent:GetParameters() end


---@class UAudioRequirementPreset : UDataAsset
---@field Query FGameplayTagQuery
local UAudioRequirementPreset = {}



---@class USoundHandleSubsystem : UAudioEngineSubsystem
local USoundHandleSubsystem = {}


